﻿unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Microsoft.DirectX.AudioVideoPlayback;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    muzyka: Audio;
  public
    constructor Create;
    procedure UruchomAudio;
    procedure KoniecMuzyki(sender: System.Object; e: System.EventArgs);
    procedure Zamkniecie(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(292, 266);
  Self.Name := 'TWinForm';
  Self.Text := 'DirectX.NET Przykład Audio 1';
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
  UruchomAudio;
end;

procedure TWinForm.UruchomAudio;
begin
  //Utwórz klase audio dla danego pliku
  muzyka := Audio.Create('TECH.wav');
  //Dodaj procedurę obsługi zdarzeń, gdy odgrywanie sie skończy...
  Include(muzyka.Ending,Self.KoniecMuzyki);
  //...oraz zwolnimy zasoby na zakończenie programu.
  Include(Self.Closing,Self.Zamkniecie);
  //Odegraj dżwięk
  muzyka.Play();
end;

procedure TWinForm.KoniecMuzyki(sender: System.Object; e: System.EventArgs);
begin
  if (muzyka <> nil) then
  begin
    try
//      muzyka.Stop();
      muzyka.Play();
    except
      on Exception do Self.Close;
    end;
  end;
end;

//Zwolnij zasoby w trakcie zamykania aplikacji
procedure TWinForm.Zamkniecie(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
begin
  if(muzyka <> nil) then
  begin
    if(muzyka.Playing) then
      muzyka.Stop();
    muzyka.Dispose();
  end;
end;

end.
